#ifndef KRAMPUS_INC_NINI_HPP
#define KRAMPUS_INC_NINI_HPP

#include <iostream>

#include <allegro5/allegro.h>
#include <allegro5/allegro_audio.h>

#include <inc/map.hpp>
#include <inc/random.hpp>

using std::cout;

class Nini {

  public:

    Nini(void);

    bool loadBitmap(void);

    float getX(void);

    float getY(void);

    void move(const bool *);

    void spawn(void);

    void update(void);

    void render(const float, const float);

    void moveUp(void);

    void moveDown(void);

    void moveLeft(void);

    void moveRight(void);

    void setObjects(Map *, Random *);

    void destroyBitmap(void);

    void setFacingDirection(const unsigned int);

    void meow(void);

  private:

    float x;
    float y;

    float move_speed;

    bool reset;

    bool meowing;

    bool moving[4];
    bool is_moving;

    unsigned int ticks;
    unsigned int frame;

    unsigned int start_tile;
    unsigned int stop_tile;

    bool facing_direction[2];

    ALLEGRO_BITMAP *bitmap;

    ALLEGRO_SAMPLE *meow_sample;

    Map *TileMap;
    Random *RNG;
};

#endif
